/*
 * Himax_touch_driver.h
 *
 *      Author: 903621
 */

#ifndef HIMAX_TOUCH_DRIVER_H_
#define HIMAX_TOUCH_DRIVER_H_

#ifndef UNITTEST
#include "input/mtouch_driver.h"
#include <sys/neutrino.h>
#include <sys/dispatch.h>
#include <screen/screen.h>
#include "lib_display_binder.h"
#include "dcmd_pm.h"
#else
#include "touchscreen_header.h"
#include "ipc_header.h"
#endif
#include "fidm_touch.h"
#include "faceplate_rm.h"

#define MAX_TOUCH            0x0A
#define I2C_DEV                "/dev/i2c5"
#define GPIO_DEV               "/dev/gpio"
#define H_I2C_SLAVE_ADDR      0x48
#define H_CMD_EVENT_STACK   0x30
#define H_PANEL_WIDTH        1920
#define H_PANEL_HEIGHT        1080
#define I2C_MAX_XFER        256
#define GPIO_INTR_PIN        15

#define PM_DEV_NODE                    "/dev/pm"
#define HIMAX_MAX_NUM_TOUCHPTS        10
#define TOUCH_INFO_SIZE     56

#define HIMAX_PULSE_PRIORITY     (21)
#define HIMAX_PULSE_CODE                        _PULSE_CODE_MINAVAIL
/* Pulse codes for receiving pulses from power manager */
#define HIMAX_PM_PREPARE_PULSE                   (_PULSE_CODE_MINAVAIL+5)
#define HIMAX_PM_SUSPEND_PULSE                   (_PULSE_CODE_MINAVAIL+6)
#define HIMAX_PM_RESUME_PULSE                    (_PULSE_CODE_MINAVAIL+7)

#define DEV_CONTROL_PATH     "dev/vcd/display-binder/control"

#define RTD_DATA             4
#define RTD_COUNTER          44
#define KNOB_DATA            54
#define KNOB_RTD_DATA        45

#ifdef UNITTEST
#define sched_param ut_sched_param
#define sigevent ut_sigevent
#endif

typedef struct _pre_touch_state_t {
    uint8_t contact;
} pre_touch_state_t;

struct himax_mt_data {
    int num_prv_rec; /* Number of previous touch records */
};

typedef struct _touch_state {
    uint16_t x;
    uint16_t y;
    uint8_t contact;
    contact_type_e type;
    uint32_t pressure;
    uint32_t orientation;
    uint8_t is_valid;
    uint8_t t;
} touch_state_t;

typedef struct _himax_ic_data {
    int vendor_arch_ver;
    int vendor_config_ver;
    int vendor_touch_cfg_ver;
    int vendor_display_cfg_ver;
    int vendor_cid_maj_ver;
    int vendor_cid_min_ver;
    int vendor_panel_ver;
    int vendor_sensor_id;
    int ic_adc_num;
    uint8_t vendor_config_date[12];
    uint8_t vendor_cus_info[12];
    uint8_t vendor_proj_info[12];
    uint8_t vendor_ic_id[13];
    int HX_RX_NUM;
    int HX_TX_NUM;
    int HX_BT_NUM;
    int HX_X_RES;
    int HX_Y_RES;
    int HX_MAX_PT;
    bool HX_XY_REVERSE;
    bool HX_INT_IS_EDGE;
} himax_ic_data;

typedef struct _himax_i2c_dev_t {
    struct mtouch_device* inputevents_hdl;

    pthread_t isr_thread;
    unsigned thread_priority;

    int thread_chid;
    int thread_coid;
    pthread_attr_t thread_attr;
    struct sched_param thread_param;
    struct sigevent thread_event;

    name_attach_t *attach;
    char *attach_point;

    pthread_t fidm_thread;
    name_attach_t *fidm_attach;
    int fidm_coid;
    char *fidm_attach_point;

    unsigned int width;
    unsigned int height;
    unsigned int max_touchpoints;
    uint32_t seq_id;
    touch_state_t state[MAX_TOUCH];
    uint8_t pre_finger_state[MAX_TOUCH];
    uint8_t prev_touch_state[MAX_TOUCH];

    /* Board Specific */
    unsigned reset_gpio_pin;
    unsigned tp_intr;
    uint32_t tp_intr_gpio;
    int tp_iid;
    struct sigevent tp_intrevent;

    /* I2C */
    int i2c_fd;
    char* i2c_devname;
    unsigned i2c_speed;
    unsigned i2c_slave_addr;

    int max_xfer;
    uint8_t wr_buf[512];
    struct himax_mt_data md;
    himax_ic_data *ic_data;

    /* window */
    unsigned int win_height;
    unsigned int win_width;
    unsigned int win_xpos;
    unsigned int win_ypos;
    unsigned int disp_id;
    char* win_name;

    unsigned verbose;

    /* pm */
    char* pm_dev;
    int pm_fd;
    enum pm_state himax_pm_state;

    char* dev_ctrl_path;
    char* dev_status_path;

    uint8_t rtd_data[MAX_RTD_DATA_LENGTH];
    int rtd_len;
    bool rtd_readflag;

    uint8_t knob_rtd[MAX_KNOB_RTD_DATA_LENGTH];
    int knob_rtd_len;
    bool knob_rtd_readflag;

    /* screen */
    screen_context_t screen_ctx;
    screen_window_t window;

    int faceplate_coid;
    int8_t knob_data;

    int display_group_id;
    unsigned sync_point;

    bool HW_Init_status;

    uint8_t hx_coord_buf[TOUCH_INFO_SIZE];
    int hx_point_num;

    char* log_name;
} himax_dev_t;


extern int himax_mcu_read_FW_ver(himax_dev_t *himax);
int hx83192_sense_off(himax_dev_t *himax);
int himax_create_qvm_window(himax_dev_t *himax);
int himax_tp_intr_attach(himax_dev_t *himax);
int himax_i2c_write(int fd, uint8_t addr, uint8_t *w_data, int w_len);
int himax_i2c_combined_writeread(int fd, uint8_t addr, uint8_t *r_data, int r_len);
int himax_register_read(int fd, uint8_t *read_addr, int read_len, uint8_t *read_data);
int himax_register_write(int fd, uint8_t *write_addr, uint8_t *write_data);
int himax_get_display_grpid(himax_dev_t *himax);
void error_memory(const char * fmt, ...);
void himax_release_touch(himax_dev_t *himax);

#endif /* HIMAX_TOUCH_DRIVER_H_ */
